/**
 * Returns a debounced function that as long as it continues to be invoked,
 * will not be triggered until it stops being called for N milliseconds.
 */
function debounce(func: Function, wait = 300) {
  let timeout;
  return function() {
    const context = this;
    const args = arguments;
    clearTimeout(timeout);
    timeout = setTimeout(() => {
      timeout = null;
      func.apply(context, args);
    }, wait);
  }
}

export default debounce;
export { debounce };
