/**
 * @fileoverview Defines the webpack configuration.
 */

const path = require('path');
const webpack = require('webpack');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const isProduction = process.env.NODE_ENV === 'production' || process.argv.indexOf('-p') !== -1;

/**
 * @config Webpack
 */
const config = {
  mode: isProduction ? 'production' : 'development',
  entry: {
    'foresight': './src/foresight.ts',
    'foresight.min': './src/foresight.ts',
  },
  output: {
    path: path.join(__dirname, isProduction ? 'dist' : 'build'),
    publicPath: '/',
    library: 'Foresight',
    libraryTarget: 'umd',
    filename: '[name].js',
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        use: {
          loader: 'awesome-typescript-loader',
          options: {
            configFileName: isProduction ? 'tsconfig.prod.json' : 'tsconfig.json'
          }
        },
      }
    ]
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  },
  optimization: {
    minimize: isProduction,
    minimizer: [new UglifyJsPlugin({
      include: /\.min\.js$/
    })],
  },
  devtool: false,
}


// Remove minified build on non-production builds
if (!isProduction) {
  delete config.entry['foresight.min'];
}


module.exports = config;