/**
 * @fileoverview Defines the webpack configuration.
 */

const path = require('path');
const webpack = require('webpack');
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const isProduction = process.env.NODE_ENV === 'production' || process.argv.indexOf('-p') !== -1;

/**
 * @config Webpack
 */
const config = {
  mode: isProduction ? 'production' : 'development',
  entry: {
    'foresight': './src/foresight.js',
    'foresight.min': './src/foresight.js',
  },
  output: {
    path: path.join(__dirname, isProduction ? 'dist' : 'build'),
    publicPath: '/',
    library: 'Foresight',
    libraryTarget: 'umd',
    filename: '[name].js',
  },
  module: {
    rules: [
      {
        test: /\.jsx?$/,
        exclude: /node_modules/,
        use: ['babel-loader'],
      }
    ]
  },
  optimization: {
    minimize: isProduction,
    minimizer: [new UglifyJsPlugin({
      include: /\.min\.js$/
    })],
  }
}


// Remove minified build on non-production builds
if (!isProduction) {
  delete config.entry['foresight.min'];
}


module.exports = config;