# Foresight
### Foresight is an analytics library that allows for declarative event tracking.

* Lightweight (<4kb minified and gzipped)
* Declarative event tracking
* Performant

## Installation

### Direct download
Download and install the latest distribution file from this
Git repository and load it in your webpage. For production cases, we encourage you to download the minified version ([`foresight.min.js`](dist/foresight.min.js))

```html
<script src="/path/to/foresight.min.js"></script>
```

### Installation via `npm` or `yarn`
While this package is not available in the npm registry, you can still use package managers to install Foresight.

```bash
$ npm install git+https://git.forefront.com.my/lib/foresight.git

# or

$ yarn add git+https://git.forefront.com.my/lib/foresight.git
```

```js
// ES6 Import
import Foresight from 'foresight';

// CommonJS
var Foresight = require('foresight');
```


## Basic Usage

To initialise Foresight, call its constructor. Pass an optional configuration object as a parameter if needed.

```js
var foresight = new Foresight({ /* ... */ });
```

You can then track elements by adding HTML attributes on elements. The value of
the attribute configures the event to be sent, using the following format:

```ini
data-track="<event category>;<event action>;<event label>"
```

`event category` and `event action` are required fields, while `event label` is optional.

---

### Tracking clicks

Clicks are tracked by setting the `data-track` attribute.

```html
<a href="/register" data-track="home;register cta">Register</a>
```

The above markup would send the following event data when clicked:

| Field           | Value          |
| --------------- | -------------- |
| `eventCategory` | `home`          |
| `eventAction`   | `register cta`  |
| `eventLabel`    | `null`          |

GA4 event tracking is also supported, example:

| `data-track` value                   | `category` | `action`  | `label`         |
|:--------------------------------------|:----------------|:---------------|:---------------------|
| `"nav;click;new page"`                | `nav`            | `click`        | `new page`           |
| `"form;submit;contact us"`            | `form`           | `submit`       | `contact us`         |
| `"button;click;download brochure"`    | `button`         | `click`        | `download brochure`  |
| `"play video"`                        | *(none)*         | `play video`   | *(none)*             |

---

### Tracking views

Views are tracked by setting the `data-track-view` attribute.

```html
<div class="project" data-track-view="home;view projects;project a">
  <!-- Content -->
</div>
```

The above markup would send the following event data when the `div` enters the viewport:

| Field           | Value           |
| --------------- | --------------- |
| `eventCategory` | `home`          |
| `eventAction`   | `view projects` |
| `eventLabel`    | `project a`     |

---

### Tracking custom metrics and custom dimensions

Custom metrics and dimensions can be tracked by attaching additional HTML attributes
under the `data-track:metrics:<metric_name>` or `data-track:dimensions:<metric_name>` namespace. The value of the attribute will be the value of the metric/dimension. You can have multiple custom metrics/dimensions per element.

The follow example will send a value of `1` to the custom metric in the `metric1` index.

```html
<button data-track="clicks;register-btn" data-track:metrics:metric1="1">
  Register
</button
```

Refer to Google Analytics documentation on what `metric_name` should be.
* **[analytics.js](https://developers.google.com/analytics/devguides/collection/analyticsjs/custom-dims-mets)**
* **[gtag.js](https://developers.google.com/analytics/devguides/collection/gtagjs/custom-dims-mets)** — `metric_name` should be the name provided in `custom_map`

## Configuration

```js
{ 
  /** Defer tracking initialisation. */
  defer: false

  /** Configure the intersection observer. */
  observerOptions: { /* Refer to Intersection Observer documentation */ }

  /** Treat clicks as an interactive event. Defaults to `true`. */
  clicksAreInteractions: true

  /** Treat views as an interactive event. Defaults to `false`. */
  viewsAreInteractions: false
}
```

## Methods

#### `track(element: Element)`
Start tracking an element for events.

This method is useful if you dynamically add new DOM elements.

Parameters:
* `element: Element` The element to track.

---

#### `untrack(element: Element)`
Stop tracking an element for events.

Parameters:
* `element: Element` The element to track.

---

#### `start(root: Element)`
Start tracking all elements with tracking attributes for events. You don't need to call this method unless you set the `defer` option to `true`.

This method is idempotent, you can call it multiple times and it won't add duplicate listeners.

Parameters:
* `root: Element` The container to scan for elements. Defaults to `body`.

---

#### `send(data: EventData)`
Manually send an analytics event data.

Parameters:
* `data: EventData` An object containing the event data with the following keys:
  * `category: string`
  * `action: string`
  * `label: string`
  * `interaction: boolean`

---

#### `sendPageView(pagePath: string)`
Manually send a page_view event to Google Analytics 4.

Parameters:
* `pagePath: string` (optional) — The path of the page to report. Defaults to the current location pathname.

---

Copyright © 2018 FOREFRONT International Sdn Bhd.